class V1::UserPresenter < V1::BasePresenter
  def initialize(user, context: nil)
    super
    @user = user
  end

  def as_json(options={})
    json = @user.as_json(options)

    # Grab Person from edb and merge
    if json && json.key?('id')
      person_response = edb.person(json['id']).body
      person = JSON.parse(person_response)
      json = person.merge(json) if person.respond_to?(:merge)
      json.delete('user_id')
    end

    # If a user has no pending email change and is member of an organization
    # we consider it "verified."
    # TODO since service/response uses presenters and passport->edb data might
    # not be present, we rescue here.
    json['is_verified'] = json['email_new'].blank? && !json['organization_ids'].empty? rescue false

    json
  end
end
