class EdbService < Service
  endpoint ENV['EDB_HOST'] || "edb.esports.service"
  version 'v1'

  def teams(params = {}, **options)
    get('teams', params: params, **options)
  end

  def team(params = {}, **options)
    get("teams/#{params.delete('id')}", params: params, **options)
  end

  def create_team(params = {}, **options)
    post('teams', params: params, **options)
  end

  def update_team(params = {}, **options)
    patch("teams/#{params.delete('id')}", params: params, **options)
  end

  def tournaments(params = {}, **options)
    get('tournaments', params: params, **options)
  end

  def tournament(params = {}, **options)
    get("tournaments/#{params.delete('id')}", params: params, **options)
  end

  def create_tournament(params = {}, **options)
    post('tournaments', params: params, **options)
  end

  def update_tournament(params = {}, **options)
    patch("tournaments/#{params.delete('id')}", params: params, **options)
  end

  def tournament_entries(params = {}, **options)
    get('tournament_entries', params: params, **options)
  end

  def create_tournament_entry(params = {}, **options)
    post('tournament_entries', params: params, **options)
  end

  def update_tournament_entry(params = {}, **options)
    patch("tournament_entries/#{params.delete('id')}", params: params, **options)
  end

  def delete_tournament_entry(params = {}, **options)
    delete("tournament_entries/#{params.delete('id')}", params: params, **options)
  end

  def tournament_stages(params = {}, **options)
    get('tournament_stages', params: params, **options)
  end

  def tournament_stage(params = {}, **options)
    get("tournament_stages/#{params.delete('id')}", params: params, **options)
  end

  def create_tournament_stage(params = {}, **options)
    post('tournament_stages', params: params, **options)
  end

  def update_tournament_stage(params = {}, **options)
    patch("tournament_stages/#{params.delete('id')}", params: params, **options)
  end

  def delete_tournament_stage(params = {}, **options)
    delete("tournament_stages/#{params.delete('id')}", params: params, **options)
  end

  def person(id, params = {}, **options)
    get("people/#{id}", params: params, **options)
  end

  def update_person(params = {}, **options)
    patch("people/#{params.delete('id')}", params: params, **options)
  end

  def accept_team_invitation(params = {}, **options)
    patch("team_invitations/#{params.delete('id')}/accept", params: params, resource: 'team', **options)
  end

  def create_team_invitation(params = {}, **options)
    post("team_invitations", params: params, **options)
  end

  def delete_team_invitation(params = {}, **options)
    delete("team_invitations/#{params.delete('id')}", params: params, **options)
  end

  def get_team_members(params = {}, **options)
    get("teams/#{params.delete('team_id')}/members", params: params, **options)
  end

  def get_team_member(params = {}, **options)
    get("teams/#{params.delete('team_id')}/members/#{params.delete('member_id')}", params: params, **options)
  end

  def create_team_member(params = {}, **options)
    post("teams/#{params.delete('team_id')}/members", params: params, **options)
  end

  def update_team_member(params = {}, **options)
    patch("teams/#{params.delete('team_id')}/members/#{params.delete('member_id')}", params: params, **options)
  end

  def remove_team_member(params = {}, **options)
    delete("teams/#{params.delete('team_id')}/members/#{params.delete('member_id')}", params: params, **options)
  end

  def get_team_users(params = {}, **options)
    get("teams/#{params.delete('team_id')}/users", params: params, **options)
  end

  def create_team_user(params = {}, **options)
    post("teams/#{params.delete('team_id')}/users", params: params, **options)
  end

  def remove_team_user(params = {}, **options)
    delete("teams/#{params.delete('team_id')}/users/#{params.delete('user_id')}", params: params, **options)
  end

  def user_event(params = {}, **options)
    post('user_events', params: params, **options)
  end

  # Articles

  def articles(params = {}, **options)
    get('articles', params: params, **options)
  end

  def article(params = {}, **options)
    get("articles/#{params.delete('id')}", params: params, **options)
  end

  def create_article(params, **options)
    post('articles', params: params, **options)
  end

  def update_article(params, **options)
    patch("articles/#{params.delete('id')}", params: params, **options)
  end

  def delete_article(params, **options)
    delete("articles/#{params.delete('id')}", params: params, **options)
  end

  # Leagues

  def leagues(params = {}, **options)
    get('leagues', params: params, **options)
  end

  def league(params = {}, **options)
    get("leagues/#{params.delete('id')}", params: params, **options)
  end

  def create_league(params = {}, **options)
    post('leagues', params: params, **options)
  end

  def update_league(params = {}, **options)
    patch("leagues/#{params.delete('id')}", params: params, **options)
  end

  def delete_league(params = {}, **options)
    delete("leagues/#{params.delete('id')}", params: params, **options)
  end

  # Seasons

  def seasons(params = {}, **options)
    get('seasons', params: params, **options)
  end

  def season(params = {}, **options)
    get("seasons/#{params.delete('id')}", params: params, **options)
  end

  def create_season(params = {}, **options)
    post('seasons', params: params, **options)
  end

  def update_season(params = {}, **options)
    patch("seasons/#{params.delete('id')}", params: params, **options)
  end

  def delete_season(params = {}, **options)
    delete("seasons/#{params.delete('id')}", params: params, **options)
  end

  # Games

  def games(params = {}, **options)
    get('games', params: params, **options)
  end

  def game(params = {}, **options)
    get("games/#{params.delete('id')}", params: params, **options)
  end

  def create_game(params = {}, **options)
    post('games', params: params, **options)
  end

  def update_game(params = {}, **options)
    patch("games/#{params.delete('id')}", params: params, **options)
  end

  def delete_game(params = {}, **options)
    delete("games/#{params.delete('id')}", params: params, **options)
  end

  # Matches

  def matches(params = {}, **options)
    get('matches', params: params, **options)
  end

  def match(params = {}, **options)
    get("matches/#{params.delete('id')}", params: params, **options)
  end

  def create_match(params = {}, **options)
    post('matches', params: params, **options)
  end

  def update_match(params = {}, **options)
    patch("matches/#{params.delete('id')}", params: params, **options)
  end

  def delete_match(params = {}, **options)
    delete("matches/#{params.delete('id')}", params: params, **options)
  end

  # Series

  def series(params = {}, **options)
    get('series', params: params, **options)
  end

  def find_series(params = {}, **options)
    get("series/#{params.delete('id')}", params: params, **options)
  end

  def create_series(params = {}, **options)
    post('series', params: params, **options)
  end

  def update_series(params = {}, **options)
    patch("series/#{params.delete('id')}", params: params, **options)
  end

  def delete_series(params = {}, **options)
    delete("series/#{params.delete('id')}", params: params, **options)
  end

  # Images

  def images(params = {})
    get('images', params: params)
  end

  def image(params = {})
    get("images/#{params.delete(:id)}", params: params)
  end

  def create_image(params = {})
    post('images', params: params)
  end

  def update_image(params = {})
    patch("images/#{params.delete(:id)}", params: params)
  end

  def delete_image(params = {})
    delete("images/#{params.delete(:id)}", params: params)
  end

  # Events

  def events(params = {}, **options)
    get('events', params: params, **options)
  end

  def event(params = {}, **options)
    get("events/#{params.delete('id')}", params: params, **options)
  end

  def create_event(params = {}, **options)
    post('events', params: params, **options)
  end

  def update_event(params = {}, **options)
    patch("events/#{params.delete('id')}", params: params, **options)
  end

  def delete_event(params = {}, **options)
    delete("events/#{params.delete('id')}", params: params, **options)
  end
end
