class PassportService < Service
  endpoint ENV['PASSPORT_HOST'] || "tourney-passport.esports.service"
  version 'v1'

  def auth(provider, params: {}, **options)
    raise Service::ParameterMissing, "Provider required" unless provider
    params['retry'] ||= 0
    params['retry'] += 1
    get("/auth/#{provider}", params: params, **options)
  end

  def token(ident, **options)
    get("tokens/#{ident}", **options)
  end

  def callback(provider, params: {}, **options)
    get("/auth/#{provider}/callback", params: params, **options)
  end

  def client(ident, **options)
    get("clients/#{ident}", **options)
  end

  def users(params = {}, **options)
    get('users', params: params, **options)
  end

  def user(params = {}, **options)
    get("users/#{params.delete('id')}", params: params, **options)
  end

  def verify_email(params = {}, **options)
    get('users/verify', params: params, **options)
  end

  def update_user(params = {}, **options)
    patch("users/#{params.delete('id')}", params: params, **options)
  end
end
