class Service
  class Response < Hash
    attr_reader :presenter, :context, :response

    def initialize(context: nil, path: nil, response: nil, resource: nil)
      @context = context
      @response = response
      @path = path
      resource = resource || path.match(%r{^/?([^/?]+)})[1]
      @presenter = "V1::#{resource.singularize.camelize}Presenter".constantize
      self[:json] = json
      self[:status] = @response.status
    end

    def method_missing(method, *args)
      response.send(method, *args)
    end

    def json(options: {})
      result = { status: response.status }

      case @response.status
      when 200
        json = response.body.present? ? JSON.parse(response.body) : {}
        if json.is_a?(Array)
          data = json.map {|u| presenter.new(u, context: context)}
        else
          data = presenter.new(json, context: context)
        end
        result[:data] = data
      else
        begin
          result[:data] = JSON.parse(response.body)
        rescue
          Rollbar.warning("HTTP #{@response.status} reply to #{@path} is not a JSON")
          result[:data] = response.body
        end
      end

      result
    end
  end
end
