#!/bin/bash

name=tourney-edge
region=us-west-2
ecr_staging=157383839067.dkr.ecr.us-west-2.amazonaws.com/tourney-edge
ecr_production=954268612818.dkr.ecr.us-west-2.amazonaws.com/tourney-edge

function ensure {
    "$@"
    local status=$?
    if [ $status -ne 0 ]; then
        echo "error with $1" >&2
        exit 1
    fi
    return $status
}

branch=`git rev-parse --abbrev-ref @`
version=`git rev-parse --short HEAD`

echo "branch: $branch version: $version GIT_COMMIT: $GIT_COMMIT"

read -p "Build docker image? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  ensure git archive $branch | bzip2 > docker/app.tar.bz2
  ensure docker build -t ${name}:latest .
fi

read -p "Push docker image? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  case "$1" in
    production)
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-aws`
      if [ $? -ne 0 ]; then `aws ecr get-login --no-include-email --region ${region}`; fi
      ensure docker tag ${name}:latest ${ecr_production}:latest
      ensure docker push ${ecr_production}:latest
      ;;
    staging)
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-dev`
      if [ $? -ne 0 ]; then `aws ecr --no-include-email get-login --region ${region}`; fi
      ensure docker tag ${name}:latest ${ecr_staging}:latest
      ensure docker push ${ecr_staging}:latest
      ;;
  esac
fi
