require File.expand_path('../boot', __FILE__)

require "rails"
# Pick the frameworks you want:
require "active_model/railtie"
require "active_job/railtie"
# require "active_record/railtie"
require "action_controller/railtie"
require "action_mailer/railtie"
require "action_view/railtie"
require "action_cable/engine"
# require "sprockets/railtie"
require "rails/test_unit/railtie"

# Require the gems listed in Gemfile, including any gems
# you've limited to :test, :development, or :production.
Bundler.require(*Rails.groups)

module Edge
  class Application < Rails::Application
    config.api_only = true

    # Lograge
    config.lograge.enabled = true
    # https://github.com/roidrage/lograge/pull/227
    config.lograge.base_controller_class = 'ActionController::API'
    config.lograge.formatter = Lograge::Formatters::Json.new
    config.lograge.custom_payload do |controller|
      {
        id: controller.request.request_id,
        ip: controller.request.ip,
        params: controller.params.to_unsafe_h,
        headers: Hash[*controller.request.headers.select do |k,v|
          k.match(/^HTTP_/)
        end.flatten]
      }
    end
  end
end
