Rails.application.routes.draw do
  api_version(module: "V1", path: { value: "v1" }) do
    resources :leagues
    resources :seasons
    resources :series
    resources :matches
    resources :docs, only: [:index]
    resources :team_invitations do
      member do
        patch :accept
      end
    end
    resources :articles
    resources :tournaments
    resources :tournament_stages
    resources :tournament_entries
    resources :games
    resources :images
    resources :teams do
      resources :members, controller: :team_members, param: :member_id
      resources :users, controller: :team_users, param: :user_id
    end
    resources :users do
      collection do
        get 'verify/:email_token', to: 'users#verify_email'
        get :auth, to: 'passport#auth'
        get 'auth/:provider', to: 'passport#auth'
        get 'auth/callback/:provider',
          as: :callback,
          to: 'passport#callback'
      end
    end
    resources :events
    get 'schedule', to: 'schedule#index'
  end

  get '/cache/clear', to: 'cache#clear'
  get '/health', to: 'health#health'
  get '*missing', to: 'application#missing', status: :not_found
  root to: 'health#health'
end
