def runspecs = '''
export RAILS_ENV=test
env | sort
docker --version
docker-compose --version

docker-compose rm -vf
docker-compose build
docker-compose run tourney-edge bundle
docker-compose run tourney-edge bundle exec rspec
'''

def deploy = '''
yes | ./build.sh staging
docker run \
  -v `pwd`:/build \
  -e AWS_ACCESS_KEY_ID \
  -e AWS_SECRET_ACCESS_KEY \
  docker.internal.justin.tv/esports/ecs-deploy
'''

def notify = '''
export SLACK_WEBHOOK=https://hooks.slack.com/services/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
export SLACK_CHANNEL=esports-mon
docker pull docker.internal.justin.tv/esports/notify-slack:latest && \
docker run \
  -v `pwd`:/build \
    --env-file <(env | grep "\\(SLACK_\\|BUILD_\\|JOB_\\|GIT_\\)") \
    docker.internal.justin.tv/esports/notify-slack:latest
'''

def notifySuccess = '#!/bin/bash\nexport BUILD_STATUS=success' + notify
def notifyFailure = '#!/bin/bash\nexport BUILD_STATUS=failure' + notify

freeStyleJob('esports-tourney-edge') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'esports/tourney-edge', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell(runspecs)
  }
  publishers {
    postBuildTask {
      task('SUCCESS', notifySuccess)
      task('marked build as failure', notifyFailure)
    }
  }
}

freeStyleJob('esports-tourney-edge-deploy') {
  using 'TEMPLATE-autobuild'
  wrappers {
    credentialsBinding {
      string 'AWS_ACCESS_KEY_ID', 'twitch-esports-dev-access-key'
      string 'AWS_SECRET_ACCESS_KEY', 'twitch-esports-dev-secret-key'
    }
  }
  scm {
    git {
      remote {
        github 'esports/tourney-edge', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
      branches 'origin/master'
    }
  }
  steps {
    shell(runspecs)
    shell(deploy)
  }
  publishers {
    postBuildTask {
      task('SUCCESS', notifySuccess)
      task('marked build as failure', notifyFailure)
    }
  }
}
