require 'rails_helper'

RSpec.describe CacheController, type: :controller do
  before :all do
    skip "Can't test caching behavior when Rails.cache is nil" if Rails.cache.nil?
  end

  before :each do
    Rails.cache.clear
  end

  it 'should clear the cache on a GET to /cache/clear' do
    Rails.cache.write('foo', 'FOO')
    expect(Rails.cache.exist?('foo')).to eq(true)
    get :clear
    expect(response.status).to eq(200)
    expect(Rails.cache.exist?('foo')).to eq(false)
  end
end
