require 'rails_helper'

describe V1::ImagesController, type: :controller do
  [ [:get, :index],
    [:post, :create],
    [:patch, :update],
    [:delete, :destroy]
  ].each do |http_method, action|
    it "should require Client-ID or User-ID for ##{action.to_s}" do
      has_id = action != :index
      stub_request(http_method, %r{/v1/images}).to_return(status: 200, body: '{}')
      expect(controller).to receive(:set_client!)
      if has_id
        method(http_method).call(action, params: {id: 'an_image'})
      else
        method(http_method).call(action)
      end
      expect(response.status).to eq(200)
    end
  end

  it 'should not require Client-ID or User-ID for #show' do
    stub_request(:get, %r{/v1/images/an_image}).to_return(status: 200, body: '{}')
    expect(controller).to_not receive(:set_client!)
    get :show, id: 'an_image'
  end
end
