require 'rails_helper'

describe V1::PassportController do
  describe '#callback_params' do
    it 'should accept both state and token parameters' do
      controller.params = {
        provider: 'twitch',
        state: 'abc',
        token: 'def',
        test: 'test'
      }
      params = controller.instance_eval{ callback_params }
      expect(params).to include(:token)
      expect(params).to include(:state)
      expect(params).to_not include(:test)
    end
  end

  describe '#auth' do
    it 'should call handle_auth! when no token is present' do
      expect(controller.instance_eval{ token }).to be(nil)
      expect(controller).to receive(:handle_auth!)
      controller.auth
    end
  end
end
