require 'rails_helper'

describe V1::TournamentsController, type: :controller do
  stub_client_validation(self)

  before :all do
    @tournaments = FactoryGirl.build_list(:tournament, 5)
    @tournament = @tournaments[0]
  end

  context 'GET /tournaments' do
    it 'should render a JSON using an array of TournamentPresenters' do
      stub_request(:get, %r{/v1/tournaments$}).
        to_return(body: @tournaments.to_json)
      expect(V1::TournamentPresenter).to receive(:new).and_call_original.
        exactly(@tournaments.length).times

      get :index, params: {client_id: 'dev'}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Array)
    end
  end

  context 'GET /tournaments/:id' do
    it 'should render a JSON using a TournamentPresenter' do
      stub_request(:get, %r{/v1/tournaments/[^/]+$}).
        to_return(body: @tournament.to_json)
      expect(V1::TournamentPresenter).to receive(:new).and_call_original

      get :show, params: {client_id: 'dev', id: 'foo'}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end

  context 'POST /tournaments' do
    it 'should render a JSON using a TournamentPresenter' do
      stub_request(:post, %r{/v1/tournaments$}).
        to_return(body: @tournament.to_json)
      expect(V1::TournamentPresenter).to receive(:new).and_call_original

      post :create, params: {client_id: 'dev', name: 'foo', entrants_type: 'Team'}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end
end
