FactoryGirl.define do
  factory :team do
    id { SecureRandom.hex }
    sequence(:name) {|n| "Test Team #{n}"}
  end

  factory :team_invitation do
    id { SecureRandom.hex }
    token { SecureRandom.hex }
    association :team, strategy: :build
  end

  factory :tournament do
    sequence(:name) {|n| "Test Tournament #{n}"}
    entrants_type 'Team'
  end

  factory :tournament_entry do
    id { SecureRandom.hex }
  end

  factory :user do
    id { SecureRandom.hex }
    sequence(:email) {|n| "user#{n}@example.com"}
  end

  factory :person do
    first_name { Faker::Name.first_name }
    user_id { SecureRandom.hex }
    organization_ids { rand(1..3).times.collect { SecureRandom.hex } }
  end
end
