require 'rails_helper'

describe V1::BasePresenter do
  describe '#embed' do
    it 'should not choke on strings' do
      object = { test: { test: 'this is a test' } }
      presenter = V1::BasePresenter.new(object)
      presenter.embed(object, :test, :testing) do |nop|
      end
    end

    it 'should not choke on arrays' do
      object = { test: { test: ['this is a test', 'also a test'] } }
      presenter = V1::BasePresenter.new(object)
      presenter.embed(object, :test, :testing) do |nop|
      end
    end
  end

  # merge! takes a key as condition, if present it calls the block with the
  # value of that key as an argument and merge!s the object, mutating it.
  #
  # primarily used for merging "user join models" in other services with
  # passport's user response.
  describe '#merge!' do
    it 'should merge an object with the yield of the supplied block' do
      object = { id: '123', user_id: '234' }
      presenter = V1::BasePresenter.new(object)
      presenter.merge!(object, :user_id) {|id| { id: '456' } }
      expect(object[:id]).to eq('456')
    end
  end
end
