require 'rails_helper'

describe V1::TeamPresenter do
  before :all do
    @users = FactoryGirl.build_list(:user, 5)
    @people = @users.map {|u| FactoryGirl.build(:person, user_id: u.id)}
    @team = FactoryGirl.build(:team, users: @people)
  end

  it 'should merge people in by user_id' do
    @controller = V1::BaseController.new
    allow(@controller).to receive(:passport).at_least(:once)

    @people.each do |person|
      expect(@controller.passport).to receive(:user).with({'id' => person.user_id}).at_least(:once).
        and_return double(body: @users.detect{|u|u.id == person.user_id}.to_json)
    end

    pres = V1::TeamPresenter.new(@team.as_json, context: @controller)
    expect(pres.as_json['users']).to be_a(Array)
    pres.as_json['users'].each do |u|
      # Each person record should be augmented by the corresponding user record.
      # (Only users have emails, and only people have first names.)
      expect(u).to include('email')
      expect(u).to include('first_name')
    end
  end
end
