require 'rails_helper'

describe V1::UserPresenter do
  describe '#as_json' do
    before :all do
      @user = FactoryGirl.build(:user)
      @person = FactoryGirl.build(:person, user_id: @user.id)

    end

    before :each do
      @controller = V1::BaseController.new
      allow(@controller).to receive_message_chain('edb.person.body').
        and_return(@person.to_json)
    end

    it 'should merge user into edb response' do
      pres = V1::UserPresenter.new(@user.as_json, context: @controller)
      expect(pres.as_json.keys).to include('first_name')
      expect(pres.as_json['id']).to eq(@user.id)
    end

    it 'should include virtual is_verified when email_new is blank and organization_ids is not empty' do
      pres = V1::UserPresenter.new(@user.as_json, context: @controller)
      expect(pres.as_json['email_new']).to be_blank
      expect(pres.as_json['organization_ids']).to_not be_empty
    end
  end
end
