require 'rails_helper'

describe V1::TeamInvitationsController, type: :controller do
  stub_client_validation(self)

  context 'POST /team_invitations' do
    it 'should render a JSON using TeamInvitationPresenter' do
      stub_request(:post, %r{/v1/team_invitations$}).
        to_return(body: FactoryGirl.build(:team_invitation).to_json)
      expect(V1::TeamInvitationPresenter).to receive(:new).and_call_original

      post :create, params: {client_id: 'dev'}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end

  context 'PATCH /team_invitations/:id/accept' do
    it 'should render a JSON using TeamPresenter' do
      stub_request(:patch, %r{/v1/team_invitations/[^/]+/accept$}).
        to_return(body: FactoryGirl.build(:team).to_json)
      expect(V1::TeamPresenter).to receive(:new).and_call_original

      patch :accept, params: {client_id: 'dev', id: 'foo'}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end

  context 'DELETE /team_invitations/:id' do
    it 'should render a JSON using TeamInvitationPresenter' do
      stub_request(:delete, %r{/v1/team_invitations/[^/]+$}).
        to_return(body: FactoryGirl.build(:team_invitation).to_json)
      expect(V1::TeamInvitationPresenter).to receive(:new).and_call_original

      delete :destroy, params: {client_id: 'dev', id: 'foo'}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end
end
