require 'rails_helper'

describe V1::TeamMembersController, type: :controller do
  stub_client_validation(self)

  [ {action: :index,   method: :get,    with_id: false},
    {action: :show,    method: :get,    with_id: true },
    {action: :create,  method: :post,   with_id: false},
    {action: :update,  method: :patch,  with_id: true },
    {action: :destroy, method: :delete, with_id: true }
  ].each do |test_case|
    it "##{test_case[:action]} should render a JSON using TeamMemberPresenter" do
      url_regex = %r{/v1/teams/[^/]+/members#{'/[^/]+' if test_case[:with_id]}$}
      body = FactoryGirl.build(:team)
      body = [body] if test_case[:action] == :index
      stub_request(test_case[:method], url_regex).to_return(body: body.to_json)

      expect(V1::TeamPresenter).to receive(:new).and_call_original

      params = {client_id: 'dev', team_id: 'foo'}
      params[:member_id] = 'bar' if test_case[:with_id]
      method(test_case[:method]).
        call(test_case[:action], params: params)
      expect(response.status).to eq(200), ->{pp json}
    end
  end
end
