require 'rails_helper'

describe V1::TeamsController, type: :controller do
  stub_client_validation(self)

  before :all do
    @teams = FactoryGirl.build_list(:team, 5)
    @team = @teams[0]
  end

  context 'GET /teams' do
    it 'should render a JSON using an array of TeamPresenters' do
      stub_request(:get, %r{/v1/teams$}).to_return(body: @teams.to_json)
      expect(V1::TeamPresenter).to receive(:new).and_call_original.exactly(@teams.length).times

      get :index, params: {client_id: 'dev'}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Array)
    end
  end

  context 'GET /teams/:id' do
    it 'should render a JSON using a TeamPresenter' do
      stub_request(:get, %r{/v1/teams/#{@team.id}$}).to_return(body: @team.to_json)
      expect(V1::TeamPresenter).to receive(:new).and_call_original

      get :show, params: {client_id: 'dev', id: @team.id}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end

  context 'POST /teams' do
    it 'should render a JSON using a TeamPresenter' do
      stub_request(:post, %r{/v1/teams$}).to_return(body: @team.to_json)
      expect(V1::TeamPresenter).to receive(:new).and_call_original

      post :create, params: {client_id: 'dev', name: @team.name}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end
end
