require 'rails_helper'

describe V1::TournamentEntriesController, type: :controller do
  stub_client_validation(self)

  before :all do
    @entry = FactoryGirl.build(:tournament_entry)
  end

  context 'GET /tournament_entries' do
    it 'should render a JSON using an array of TournamentEntryPresenters' do
      stub_request(:get, %r{/v1/tournament_entries$}).
        to_return(body: [@entry].to_json)
      expect(V1::TournamentEntryPresenter).to receive(:new).and_call_original

      get :index, params: {client_id: 'dev'}

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Array)
    end
  end

  context 'POST /tournament_entries' do
    it 'should render a JSON using TournamentEntryPresenter' do
      stub_request(:post, %r{/v1/tournament_entries$}).
        to_return(body: @entry.to_json)
      expect(V1::TournamentEntryPresenter).to receive(:new).and_call_original

      post :create, params: {
        client_id: 'dev',
        tournament_id: 'foo',
        entrant_type: 'Team',
        entrant_id: 'bar'
      }

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end

  context 'PATCH /tournament_entries/:id' do
    it 'should render a JSON using TournamentEntryPresenter' do
      stub_request(:patch, %r{/v1/tournament_entries/[^/]+$}).
        to_return(body: @entry.to_json)
      expect(V1::TournamentEntryPresenter).to receive(:new).and_call_original

      patch :update, params: {
        client_id: 'dev',
        id: 'foo',
        entrant_type: 'Team',
        entrant_id: 'bar'
      }

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end

  context 'DELETE /tournament_entries/:id' do
    it 'should render a JSON using TournamentEntryPresenter' do
      stub_request(:delete, %r{/v1/tournament_entries/[^/]+$}).
        to_return(body: @entry.to_json)
      expect(V1::TournamentEntryPresenter).to receive(:new).and_call_original

      delete :destroy, params: { client_id: 'dev', id: 'foo' }

      expect(response.status).to eq(200), "got error reply: #{response.body.inspect}"
      expect(json['data']).to be_a(Hash)
    end
  end
end
