module RequestGroupHelpers
  def stub_client_validation(group)
    group.before :each do
      # Mock out client_id validation
      stub_request(:get, %r{/v1/clients/[^/]+$}).to_return(body: '{}')
    end

    group.after :each do
      # clean up any stubs, in case we didn't use any
      WebMock.reset!
    end
  end
end

module RequestHelpers
  def json
    JSON.parse(response.body)
  end

  def json_ids
    json['data'].map {|obj| obj['id']}
  end
end
