shared_context 'service endpoints' do |route|
  stub_client_validation(self)

  before :all do
    @route = !route.match(/^\//) ? "/v1/#{route}" : route
  end

  context "GET #{@route}" do
    it 'should respond with http status 200' do
      stub_request(:get, /#{@route}$/).to_return(body: '{}')
      get @route, params: {client_id: 'dev'}
      expect(response.status).to eq(200), response.body
    end
  end

  context "GET #{@route}/:id" do
    it 'should respond with http status 200' do
      route = [@route, 1].join('/')
      stub_request(:get, /#{route}$/).to_return(body: '{}')
      get route, params: {client_id: 'dev'}
      expect(response.status).to eq(200), response.body
    end
  end

  context "POST #{@route}" do
    it 'should respond with http status 200' do
      stub_request(:post, /#{@route}$/).to_return(body: '{}')
      post @route, params: {client_id: 'dev'}
      expect(response.status).to eq(200), response.body
    end
  end

  context "PATCH #{@route}/:id" do
    it 'should respond with http status 200' do
      route = [@route, 1].join('/')
      stub_request(:patch, /#{route}$/).to_return(body: '{}')
      patch route, params: {client_id: 'dev'}
      expect(response.status).to eq(200), response.body
    end
  end
end
