data "aws_alb" "service" {
  name = "${var.service_name}"
}

module "alarms" {
  source = "git::ssh://git@git-aws.internal.justin.tv/esports/terraform.git//modules/alarms?ref=2017-05-19"

  namespace = "tourney/${var.service_name}/${var.service_env}"
  name_prefix = "${var.service_name}_${var.service_env}"
  service_name = "${var.service_name}"

  alb_4XX = true
  alb_4XX_threshold = "10"
  alb_5XX = true
  alb_5XX_threshold = "10"
  alb_arn_suffix = "${data.aws_alb.service.arn_suffix}"
  rails = true

  insufficient_data_actions = ["${data.terraform_remote_state.aws.alarm_sns_topic_arn}"]
  alarm_actions = ["${data.terraform_remote_state.aws.alarm_sns_topic_arn}"]
  ok_actions = ["${data.terraform_remote_state.aws.alarm_sns_topic_arn}"]
}
