resource "aws_elasticache_subnet_group" "default" {
  name = "${var.service_name}-cache-subnet"
  subnet_ids = ["${split(",", lookup(data.terraform_remote_state.dev.ecs_cluster_tourney, "subnet_ids"))}"]
}

resource "aws_elasticache_cluster" "default" {
  cluster_id = "${var.service_name}-cache"
  engine  = "redis"
  engine_version = "3.2.4"
  node_type = "cache.t2.micro"
  num_cache_nodes = 1
  parameter_group_name = "default.redis3.2"
  port = 6379
  subnet_group_name = "${aws_elasticache_subnet_group.default.name}"
  security_group_ids = ["${lookup(data.terraform_remote_state.dev.ecs_cluster_tourney, "security_group_id")}"]
}
