# Tournament Project Fig Client

## Installation

Install CLI dependencies:
`brew install yarn` - [Yarn](https://yarnpkg.com/) is an alternative package manager to npm
`yarn global add webpack`
`yarn global add webpack-dev-server`

Checkout the repo & install packages:
```sh
git clone git@git-aws.internal.justin.tv:esports/tourney-fig-client.git
cd tourney-fig-client
git submodule init
git submodule update 
yarn install
```

### Dev Server

`yarn start` - This command boots a local dev server that will watch files for changes and rebuild the app.
After running this command, access the app from [http://localhost:5200/](http://localhost:5200/)

### Build

`yarn build` - This command builds `bundle.js` and outputs it to the `dist/` folder

## Notes

### Loading missing data via mergeProps

As far as I understand, dispatching actions in mergeProps is frowned upon. It 
can easily lead to complications or performance issues. However, we have no 
better place to do this right now.

Due to how we normalize data, we may have received a deeply nested object
that only contains relationship ids (e.g. team_ids) but the objects it 
references are not on the same response. To avoid failing a render, we check
for required relationships including `undefined` in mergeProps of a component,
filter `undefined` and fire whichever action will land all required data in the
store.

For an example, see [ui/components/team/manage/index.ts](ui/components/team/manage/index.ts)

Related: 
 * https://github.com/reactjs/react-redux/issues/237

### Updating tourney-sdk-react

Because yarn is a piece of !@#$, make sure you do this whenever you pin the 
submodule to a new version:

`git submodule init && git submodule update && rm -rf node_modules/tourney-sdk-react && yarn upgrade file:vendor/tourney-sdk-react`
