import {
  getTeams,
  getTournaments,
  TournamentModel,
  TournamentEntryModel
} from 'tourney-sdk-react';

import { Action } from './action-type';
import { Game } from 'common/constants';

export const SET_ACTIVE_TOURNAMENTS = 'SET_ACTIVE_TOURNAMENTS';
export interface SetActiveTournamentsAction extends Action<typeof SET_ACTIVE_TOURNAMENTS, string[]> {}

export function createSetActiveTournamentsAction(ids: string[]): SetActiveTournamentsAction {
  return {
    type: SET_ACTIVE_TOURNAMENTS,
    payload: ids
  };
}

export function getActiveTournaments() {
  return async (dispatch: any) => {
    let tournaments = await dispatch(getTournaments());
    const ids = tournaments.map((t: TournamentModel) => t.id);
    dispatch(createSetActiveTournamentsAction(ids));
    return ids;
   };
}

export type TournamentActions = SetActiveTournamentsAction;
