import {
  getSeries,
  SeriesModel
} from 'tourney-sdk-react';

import { Action } from './action-type';
import { Game } from 'common/constants';

export const SET_USER_SERIES = 'SET_USER_SERIES';
export interface SetUserSeriesAction extends Action<typeof SET_USER_SERIES, string[]> {}

export function createSetUserSeriesAction(ids: string[]): SetUserSeriesAction {
  return {
    type: SET_USER_SERIES,
    payload: ids
  };
}

export function getUserSeries(userId: string) {
  return async (dispatch: any) => {
    let series = await dispatch(getSeries({ user_id: userId }));
    const ids = series.map((s: SeriesModel) => s.id);
    dispatch(createSetUserSeriesAction(ids));
    return ids;
   };
}

export type UserActions = SetUserSeriesAction;
