import { SubSection } from './index';

export interface Game {
  title: string;
  abbr: string;
  key: string;
  backgroundAsset: string;
  boxArtAsset: string;
}

export interface Tournament {
  id: string;
  game: Game;
  slug: string;
  title: string;
  start: Date;
  end: Date;
  status: TournamentStatus;
  entries: number;
  maxEntries: number;
}

export enum TournamentStatus {
  OPEN,
  CLOSED,
  LIVE,
  FINISHED
}

export const TOURNAMENT_SUB_SECTIONS_MAP = {
  OVERVIEW: {
    key: 'OVERVIEW',
    url: '',
    title: 'overview',
    enabled: true
  },
  TEAMS: {
    key: 'TEAMS',
    url: '/teams',
    title: 'teams',
    enabled: true
  },
  RULES : {
    key: 'RULES',
    url: '/rules',
    title: 'rules',
    enabled: true
  },
  SCHEDULE : {
    key: 'SCHEDULE',
    url: '/',
    title: 'schedule',
    enabled: false
  },
  MATCHES: {
    key: 'MATCHES',
    url: '/',
    title: 'matches',
    enabled: false
  },
  VODS: {
    key: 'VODS',
    url: '/',
    title: 'vods',
    enabled: false
  },
  STANDINGS: {
    key: 'STANDINGS',
    url: '/',
    title: 'standings',
    enabled: false
  },
  BRACKETS: {
    key: 'BRACKETS',
    url: '/',
    title: 'brackets',
    enabled: false
  },
  STREAM: {
    key: 'STREAM',
    url: '/',
    title: 'stream',
    enabled: false
  }};

export const TOURNAMENT_SUB_SECTIONS: SubSection[] = [
  TOURNAMENT_SUB_SECTIONS_MAP.OVERVIEW,
  TOURNAMENT_SUB_SECTIONS_MAP.TEAMS,
  TOURNAMENT_SUB_SECTIONS_MAP.RULES,
  TOURNAMENT_SUB_SECTIONS_MAP.SCHEDULE,
  TOURNAMENT_SUB_SECTIONS_MAP.MATCHES,
  TOURNAMENT_SUB_SECTIONS_MAP.VODS,
  TOURNAMENT_SUB_SECTIONS_MAP.STANDINGS,
  TOURNAMENT_SUB_SECTIONS_MAP.BRACKETS,
  TOURNAMENT_SUB_SECTIONS_MAP.STREAM
];
