import { TournamentModel } from 'tourney-sdk-react';

import { SubSection } from 'common/constants';

// If this file gets more use, I will organize this folder better.
export const urlToTournamentSection = (section: SubSection, tournament: TournamentModel): string => {
  return `/tournaments/${tournament.id}${section.url}`;
};

export const urlForTournament = (tournament: TournamentModel): string => {
  return `/tournaments/${tournament.id}`;
};

export const logoutAndRedirect = (logout: Function, redirectUrl: string) => {
  return logout()
    .then(() => {
      window.location.href = redirectUrl;
    });
};

export const urlForSettingsSection = (section: SubSection): string => {
  return `/settings${section.url}`;
};

export const loadScript = (id: string, url: string) => {
  return new Promise((resolve, reject) => {
    const element = document.createElement('script');
    const parent = 'body';
    element.onload = () => resolve(url);
    element.onerror = () => reject(url);

    element.id = id;
    // element.async = true;
    element.src = url;
    document.body.appendChild(element);
  });
};
