import { Actions } from 'actions/actions';
import { SET_ACTIVE_TOURNAMENTS } from 'actions/tournaments';

import { TournamentsModel, DEFAULT_TOURNAMENTS_MODEL } from './model';

export function tournaments(state: TournamentsModel = DEFAULT_TOURNAMENTS_MODEL, action: Actions): TournamentsModel {
  switch (action.type) {
    case SET_ACTIVE_TOURNAMENTS:
      return Object.assign({}, state, {
        active: action.payload
      });
    default:
      return state;
  }
}
