import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import { updateUser } from 'tourney-sdk-react';

import { AppModel } from 'state/model';

import { EmailVerificationProps, EmailVerificationComponent } from './component';

function mapStateToProps(state: AppModel) {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? state.tourney.users[current] : undefined;

  return {
    loggedIn,
    user
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>) {
  return bindActionCreators({ updateUser }, dispatch);
}

export const EmailVerification = connect(mapStateToProps, mapDispatchToProps)(EmailVerificationComponent);
