import * as React from 'react';

const styles = require('./styles.scss');

interface FooterLink {
  name: string;
  url: string;
}

export class FooterComponent extends React.Component<any, any> {
  public render () {
    const ahglLogo = require('common/assets/ahgl_text_logo_gray.svg') as string;
    const twitchLogo = require('common/assets/twitch_logo.svg') as string;

    const LINKS: FooterLink[] = [{
        name: 'support',
        url: 'mailto:help@ahgl.tv'
      }, {
        name: 'legal',
        url: '#'
      }, {
        name: 'terms of service',
        url: 'https://www.twitch.tv/p/terms-of-service'
      }, {
        name: 'privacy policy',
        url: 'https://www.twitch.tv/p/privacy-policy'
      }
    ];

    const linkContent = LINKS.map((link: FooterLink) => {
      return (
        <a href={link.url} key={link.name}>
          {link.name}
        </a>
        );
    });

    return (
      <footer className="footer-container">
        <div className="logos-content">
          <img className="ahgl-logo" src={ahglLogo} />
          <div className="by">BY</div>
          <img className="twitch-logo" src={twitchLogo} />
        </div>

        <div className="link-content">
          {linkContent}
        </div>
      </footer>
    );
  }
}
