import * as React from 'react';
import { Link } from 'react-router';
import { TournamentModel } from 'tourney-sdk-react';

import { urlForTournament } from 'common/helpers';
import { Button } from 'ui/components/button';
import { Image } from 'ui/components/image';
import { Modal } from 'ui/components/modal';

import { GameModalProps } from './index';

const styles = require('./styles.scss');

export class GameModalComponent extends React.Component<GameModalProps, any> {
  public render () {
    const { closeModal, activeTournaments, loading } = this.props;

    let content = undefined;
    if ( !loading ) {
      const gameContent = activeTournaments.map(this.renderSingleTournament);
      content = (
        <div>
          <div className="modal-title">Select A Game</div>
          <div className="modal-content">{gameContent}</div>
          <div className="modal-footer">
            <span onClick={closeModal}>Cancel</span>
          </div>
        </div>
      );
    }

    return (
      <Modal classNames={['game-modal']}>
        {content}
      </Modal>
    );
  }

  private renderSingleTournament(tournament: TournamentModel) {
    const boxArt = tournament.game
      ? tournament.game.cover.preview
      : undefined;
    return (
      <Link to={urlForTournament(tournament)} className="single-game">
        <Image className="game-option" src={boxArt} />
        <Button connect="top" primary>
          Sign Up
        </Button>
      </Link>
    );
  }
}
