import * as React from 'react';
import { denormalize } from 'normalizr';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import {
  TournamentModel,
  TournamentSchema,
} from 'tourney-sdk-react';

import { getActiveTournaments } from 'actions/tournaments';
import { AppModel } from 'state/model';

import { GameModalComponent } from './component';

export interface GameModalProps {
  activeTournamentIds?: string[];
  activeTournaments?: TournamentModel[];
  loading?: boolean;
  closeModal?: any;
}

function mapStateToProps(state: AppModel, ownProps: GameModalProps): GameModalProps {
  const activeTournamentIds = state.tournaments.active;
  const idsLoaded = activeTournamentIds === undefined || activeTournamentIds.length === 0;
  const activeTournaments = idsLoaded
    ? undefined
    : denormalize(activeTournamentIds, [TournamentSchema], state.tourney);

  return {
    activeTournamentIds,
    activeTournaments,
    loading: activeTournaments === undefined
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: GameModalProps) {
  return bindActionCreators({ }, dispatch);
}

export const GameModal = connect(mapStateToProps, mapDispatchToProps)(GameModalComponent);
