import * as React from 'react';
import { GameModel, TournamentModel } from 'tourney-sdk-react';

import { Hero } from 'ui/components/hero';

const styles = require('./styles.scss');

const SWAP_TIME = 15;
type AnimationState = 'PENDING' | 'INITIALIZED' | 'ANIMATING';

interface SliderState {
  animationState?: AnimationState;
  nextSlide?: number;
}

interface SliderProps {
  content: React.ReactNode;
  animationDuration: number;
}

export class HeroSliderComponent extends React.Component<SliderProps, SliderState> {
  private swapInterval: number;
  private oldContent: React.ReactNode = undefined;

  public constructor(props: any) {
    super(props);
    this.state = {
      animationState: 'PENDING',
    };
  }

  public componentWillUpdate(nextProps: SliderProps) {
    if (nextProps.content.key !== this.props.content.key && this.props.content !== undefined) {
      this.oldContent = this.props.content;
      this.startAnimation();
    }
  }

  public render() {
    const { content } = this.props;

    let mainSlide = ['single-slide'];
    let oldSlideClasses = ['single-slide'];

    switch (this.state.animationState) {
      case 'PENDING':
        break;
      case 'INITIALIZED':
        mainSlide.push('new');
        oldSlideClasses.push('old initial');
        break;
      case 'ANIMATING':
        oldSlideClasses.push('old');
        break;
      default:
        break;
    }


    let transitioningContent = undefined;
    if (this.oldContent) {
      transitioningContent = (
        <div className={oldSlideClasses.join(' ')}>
          {this.oldContent}
        </div>
      );
    }

    return (
      <div className="hero-slider">
        <div className={mainSlide.join(' ')}>
          {content}
        </div>
        {transitioningContent}
      </div>
    );
  }

  private startAnimation() {
    this.setState({
      animationState: 'INITIALIZED',
    });
    setTimeout(() => {
      this.setState({
        animationState: 'ANIMATING',
      });
    }, 0);
    setTimeout(() => {
      this.oldContent = undefined;
      this.setState({
        animationState: 'PENDING',
      });
    }, this.props.animationDuration * 1000);
  }
}
