import * as React from 'react';
import { Link } from 'react-router';

import { AppModel } from 'state/model';
import { urlForTournament } from 'common/helpers';

const styles = require('./styles.scss');

export class HeroComponent extends React.Component<any, any> {
  public render() {
    const { tournament } = this.props;
    const animationsByGame = this.heroAnimationByGame();
    const copyByGame = this.copyByGame();
    const containerClasses = ['hero-container', tournament.game.abbr];

    return (
      <div className={containerClasses.join(' ')}>
        {animationsByGame[tournament.game.name]}
        <div className="content-container">
          <div className="title">
            {tournament.game.name} Season I
          </div>
          <div className="description">
            {copyByGame[tournament.game.name]}
            This is a description paragraph. Here you can put a description to describe descriptively a description of the tournament.
          </div>
          <div className="cta-button">
            <Link to={urlForTournament(tournament)}>
              Find Out More
            </Link>
          </div>
        </div>
      </div>
    );
  }

  private copyByGame(): {[key: string]: string} {
    return {
      'StarCraft II': 'Battle head to head in Blizzard’s RTS to see which company has the highest apm in North America. Choose from one of the three unique races to compete in a best of five series in which team members will fight one versus one against an opposing company’s team member.',
      'League of Legends': 'Enter the rift to compete five versus five in a best of three in Riot’s MOBA. Choose from over 100+ champions to defend your company’s Nexus and see who has the strongest team in North America.',
      'CS: GO': 'Compete in a best of three in Valve’s five versus five FPS title. Battle with other companies across a multitude of maps to see whose strategy is strongest.',
    };
  }

  private heroAnimationByGame(): {[key: string]: React.ReactNode} {
    const vikingImage = require('../../../common/assets/hero/viking.svg') as string;
    const planetImage = require('../../../common/assets/hero/planet.svg') as string;

    const blitz = require('../../../common/assets/hero/blitzu.svg') as string;
    const blitzHook = require('../../../common/assets/hero/blitzhook.svg') as string;
    const blitzHand = require('../../../common/assets/hero/blitzhand.svg') as string;
    const poro = require('../../../common/assets/hero/bigporo2.svg') as string;
    const poroAyay = require('../../../common/assets/hero/bigporo_ayaya.svg') as string;

    const bombImage = require('../../../common/assets/hero/bomb.svg') as string;
    const kaboomCircleImage = require('../../../common/assets/hero/kaboom-circle.svg') as string;
    const kaboomImage = require('../../../common/assets/hero/kaboom.svg') as string;

    return {
      'StarCraft II': (
        <div className="animations">
          <div className="lightspeed"/>
          <div className="content-container">
            <img src={vikingImage} className="viking-1"/>
            <img src={vikingImage} className="viking-2"/>
            <img src={vikingImage} className="viking-3"/>
          </div>
          <img src={planetImage} className="planet"/>
        </div>
      ),
      'League of Legends': (
        <div className="animations">
          <div className="whole-blitz">
            <img src={blitz} className="blitzcrank" />
            <img src={blitzHook} className="blitzhook" />
            <img src={blitzHand} className="blitzhand" />
          </div>
          <img src={poro} className="bigporo" />
          <img src={poroAyay} className="bigporo-ayaya" />
        </div>
      ),
      'CS: GO': (
        <div className="animations">
          <div className="content-container">
            <img src={bombImage} className="bomb" />
            <img src={kaboomCircleImage} className="kaboomcircle" />
            <img src={kaboomImage} className="kaboom" />
          </div>
        </div>
      )
    };
  }
}
