import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

const styles = require('./styles.scss');

const mapDispatchToProps = (dispatch: any) => {
  return { dispatch };
};

const mapStateToProps = (state: Object) => {
  return state;
};

const STEPS = [{
  title: 'Login'
}, {
  title: 'Verify Account'
}, {
  title: 'Create Team'
}];

class IntroProgressComponent extends React.Component<any, any> {

  public render() {
    const SELECTED_STEP = 1;

    const stepsContent = STEPS.map((step, idx) => {
      const classes = ['single-step'];
      if (idx === SELECTED_STEP) {
        classes.push('selected');
      }
      if (SELECTED_STEP >= idx) {
        classes.push('filled');
      }

      return (
        <li className={classes.join(' ')} key={idx}>
          <div className="bar"/>
          <div className="text">
            {idx + 1} <span className="titleText">{step.title}</span>
          </div>
        </li>
      );
    });

    return (
      <ul className="intro-progress">
       {stepsContent}
      </ul>
    );
  }
}
export const IntroProgress = connect(mapStateToProps, mapDispatchToProps)(IntroProgressComponent);
