import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import { Link } from 'react-router';

import { Placeholder } from 'ui/components/placeholder';
import { IntroProgress } from 'ui/components/home/intro-progress';

const styles = require('./styles.scss');

const mapDispatchToProps = (dispatch: any) => {
  return { dispatch };
};

const mapStateToProps = (state: Object) => {
  return state;
};

class HomeIntroComponent extends React.Component<any, any> {

  public render() {

    return (
      <div className="intro-container">
        <h1>Welcome to the new AHGL!</h1>
        <Placeholder className="site-description">Twitch is proud to announce the first season of the new After Hours Gaming League! After Hours Gaming League is a corporate esports league, created by Sean “Day9” Plott, in which companies will compete across different game titles to raise money for charity. Sean has passed the torch to Twitch and we are excited to keep the tradition going. For more information visit our <Link to="/faq">FAQ</Link>! *Click here(link) to start registering your team today!</Placeholder>
      </div>
    );
  }
}
export const HomeIntro = connect(mapStateToProps, mapDispatchToProps)(HomeIntroComponent);
