import * as React from 'react';

const styles = require('./styles.scss');

interface ImageProps {
  src: string;
  className?: string;
}

interface ImageState {
  state: 'loading' | 'loaded' | 'error';
}

export class Image extends React.Component<ImageProps, ImageState> {
  public constructor() {
    super();
    this.state = {
      state: 'loading'
    };
  }

  public handleLoad() {
    this.setState({ state: 'loaded' });
  }

  public handleError() {
    this.setState({ state: 'error' });
  }

  public render () {
    let classes = ['image', this.state.state];
    if (this.props.className) {
      classes.push(this.props.className);
    }

    return <div className={classes.join(' ')}>
      <img
        src={this.props.src}
        onLoad={this.handleLoad.bind(this)}
        onError={this.handleError.bind(this)}
      />
    </div>;
  }
}
