import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import { AppModel } from 'state/model';
import { authUser, UserModel } from 'tourney-sdk-react';

const mapDispatchToProps = (dispatch: any) => {
  return { dispatch };
};

const mapStateToProps = (state: AppModel) => {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? state.tourney.users[current] : undefined;

  return {
    loggedIn,
    user
  };
};

export class LoginLinkComponent extends React.Component<any, any> {
  public render() {
    return (
      <a onClick={this.handleClick.bind(this)}>
        {this.props.children}
      </a>
    );
  }

  private handleClick(e: MouseEvent) {
    e.preventDefault();
    if (!this.props.loggedIn) {
      this.props.dispatch(authUser());
    }
  }
}
export const LoginLink = connect(mapStateToProps, mapDispatchToProps)(LoginLinkComponent);
