import * as React from 'react';

const styles = require('./styles.scss');

interface ModalProps {
  classNames?: string[];
}

export class Modal extends React.Component<any, any> {
  public render() {
    const { classNames } = this.props;
    let modalClasses = ['modal'];
    if (classNames) {
      modalClasses = [...modalClasses, ...classNames];
    }

    return (
      <div className={modalClasses.join(' ')}>
        <div className="modal-container">
          {this.props.children}
        </div>
      </div>
    );
  }
}
