import * as React from 'react';
import { Link, browserHistory } from 'react-router';

import { LoginLink } from 'ui/components/login-link';
import { UserAvatar } from 'ui/components/user-avatar';
import { urlForTournament, logoutAndRedirect } from 'common/helpers';

const styles = require('./styles.scss');

export class NavigationMobileComponent extends React.Component<any, any> {

  public render() {
    const { open, gameMap, toggleAction, user } = this.props;
    const classes = ['mobile-nav'];
    if (open) {
      classes.push('active');
    }
    const homeImg: string = require('common/assets/menu_home.svg') as string;
    const games = gameMap.map((mapping: any) => {
      return (
        <li key={mapping.tournament.id}>
          <Link to={urlForTournament(mapping.tournament)} onClick={toggleAction}>
            <img className="boxart" src={mapping.game.cover.preview}/>
            {mapping.game.name}
          </Link>
        </li>
      );
    });

    return (
      <div className={classes.join(' ')}>
        <ul className="links">
          <Link to="/" onClick={toggleAction}>
            <li className="home-link">
              <img className="home-icon" src={homeImg} />
              Home
            </li>
          </Link>
          {games}
        </ul>
        {this.renderUserFooter()}
      </div>
    );
  }

  private renderUserFooter() {
    const { myUser, logoutUser } = this.props;
    const logout = () => {
      logoutAndRedirect(logoutUser, '/');
    };
    return myUser
      ? (
      <div className="footer">
        <div className="icon">
          <UserAvatar avatar={myUser.avatar} />
        </div>
        <i onClick={logout} className="sign-out fa fa-sign-out" />
      </div>
      )
      : undefined;
  }
}
