import * as React from 'react';
import { denormalize } from 'normalizr';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';

import {
  UserSchema,
  getGames,
  GameModel,
  TournamentSchema,
  logoutUser
} from 'tourney-sdk-react';

import { getActiveTournaments } from 'actions/tournaments';
import { AppModel } from 'state/model';

import { Navigation, NavigationProps, NavigationState } from './component';

function mapStateToProps(state: AppModel, ownProps: NavigationProps): NavigationProps {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? denormalize(current, UserSchema, state.tourney) : undefined;
  const appLoading = Object.keys(state.tourney.requests).length > 0 ? true : false;
  const activeTournamentIds = state.tournaments.active;
  const loading = activeTournamentIds === undefined || activeTournamentIds.length === 0;
  const activeTournaments = loading
    ? undefined
    : denormalize(activeTournamentIds, [TournamentSchema], state.tourney);

  return {
    activeTournamentIds,
    activeTournaments,
    loggedIn,
    appLoading,
    user,
    loading
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: NavigationProps) {
  if (ownProps.activeTournamentIds === undefined || ownProps.activeTournamentIds.length === 0) {
    dispatch(getActiveTournaments());
  }

  return bindActionCreators({ logoutUser }, dispatch);
}

export const NavigationContainer = connect(mapStateToProps, mapDispatchToProps)(Navigation) as React.ComponentClass<NavigationProps>;
