import * as React from 'react';
import { Link } from 'react-router';

import { NewsArticle } from 'common/constants';

const styles = require('./styles.scss');

export interface NewsPreviewProps {
  article: NewsArticle;
}

export class NewsPreviewComponent extends React.Component<NewsPreviewProps, any> {
  public render() {
    const { article } = this.props;
    // const imgSrc: string = require(`common/assets/${article.thumb}`) as string;
    const imgSrc = '';
    return (
      <article className="news-preview">
        <img className="thumb" src={imgSrc} />
        <div className="content">
          <div className="title">{article.title}</div>
          <div className="desc">{article.description}</div>
        </div>
        <div className="date">
          8 hours ago
        </div>
      </article>
    );
  }
}
