import * as React from 'react';
import * as Faker from 'faker';

const styles = require('./styles.scss');

export class Placeholder extends React.Component<any, any> {
  public render () {
    if (this.props.icon) {
      return <i className={[this.props.className, 'placeholder fa', this.props.icon].join(' ')}/>;
    } else if (this.props.image) {
      return <img className={['placeholder', this.props.className].join(' ')} src={this.props.image}/>;
    } else if (this.props.string) {
      return <span className={['placeholder', this.props.className].join(' ')}>
        {Faker.fake(this.props.string.toString())}
      </span>;
    }
    return <div className={['placeholder', this.props.className].join(' ')}>
      {this.props.children}
    </div>;
  }
}
