import * as React from 'react';
import * as moment from 'moment';
import { sortBy } from 'lodash';
import { TeamModel, MatchModel, OpponentModel, UserModel } from 'tourney-sdk-react';

import { ICONS } from 'common/constants';
import { Contender } from 'ui/components/tournament/contender';
import { TeamLogo } from 'ui/components/team/logo';
import { ReportingOpponent } from 'ui/components/reporting/opponent';

require('./styles.scss');

export interface ReportingMatchProps {
  match: MatchModel;
  matchNum: number;
  winners: {[key: string]: string};
  selectWinner: (matchId: string, opponentId: string) => void;
  user: UserModel;
}

export class ReportingMatch extends React.Component<ReportingMatchProps, any> {
  public constructor(props: any) {
    super(props);
  }

  public render() {
    const { match, user, matchNum } = this.props;
    if (!match) {
      return <div />;
    }

    const sortedOpponents = sortBy(match.opponents, (opp: OpponentModel) => opp.contender_id);
    const opponents: JSX.Element[] = [
      <div key={0} className={['mobile-match-num', match.state].join(' ')}>Match {matchNum}</div>,
      this.renderOpponentReporting(sortedOpponents[0]),
      <div key={1} className={['match-num', match.state].join(' ')}>Match {matchNum}</div>,
      this.renderOpponentReporting(sortedOpponents[1], true),
    ];

    return (
      <div className="reporting-match">
        {opponents}
      </div>
    );
  }

  private renderOpponentReporting(opponent: OpponentModel, reverse = false) {
    const { match, selectWinner, winners, user } = this.props;
    return (
      <ReportingOpponent
        user={user}
        match={match}
        opponent={opponent}
        key={opponent.id}
        winners={winners}
        selectWinner={selectWinner}
        reverse={reverse}
      />
    );
  }

  private opponentsAgree() {
    const { match } = this.props;
    return (!match.opponents[0].winner_id || ! match.opponents[1].winner_id) || match.opponents[0].winner_id === match.opponents[1].winner_id;
  }
}
