import * as React from 'react';
import * as moment from 'moment';
import { some, get } from 'lodash';
import { TeamModel, MatchModel, OpponentModel, UserModel } from 'tourney-sdk-react';

import { Contender } from 'ui/components/tournament/contender';
import { TeamLogo } from 'ui/components/team/logo';

require('./styles.scss');

export interface OpponentReportingProps {
  user: UserModel;
  match: MatchModel;
  opponent: OpponentModel;
  reverse: boolean;
  winners: {[key: string]: string};
  selectWinner: (matchId: string, opponentId: string) => void;
}

/* tslint:disable: cyclomatic-complexity */
export class ReportingOpponent extends React.Component<OpponentReportingProps, any> {
  public render() {
    const { user, match, opponent, selectWinner, winners, reverse } = this.props;
    let classes = ['reporting-opponent'];

    // find out if this is our opponento object
    let contestantsMap = [user.id, ...user.team_ids].reduce(
      (memo: any, obj: string) => {
        return { ...memo, [obj]: true };
      }, {});
    const myChoice = get(match.opponents.filter(
      (opp: OpponentModel) => contestantsMap[opp.contender_id])[0], 'winner_id');
    const theirChoice = get(match.opponents.filter(
      (opp: OpponentModel) => !contestantsMap[opp.contender_id])[0], 'winner_id');

    const isMatchWinner = match.winner_id === opponent.id;
    const isLocked = match.state === 'locked' || match.state === 'decided';
    const mySelected = winners[match.id] === opponent.id;
    const noSelection = !winners[match.id];
    const hasWinners = some(match.opponents.map(
      (opp: OpponentModel) => opp.winner_id));
    const markedWinner = some(match.opponents.map(
      (opp: OpponentModel) => opp.winner_id === opponent.id));
    const currentlyLoser = hasWinners && !markedWinner;
    const myMarking = myChoice === opponent.id;
    const theirMarking = theirChoice === opponent.id;

    if (isMatchWinner) {
      classes.push('match-winner');
    }

    if (isLocked) {
      classes.push('locked');
    } else if (myMarking && noSelection || mySelected) {
      classes.push('winner');
    } else if (theirMarking) {
      classes.push('marked');
    } else if (currentlyLoser) {
      classes.push('currently-loser');
    } else {
      classes.push('pending');
    }

    if (reverse) {
      classes.push('reverse');
    }

    return (
      <div className={classes.join(' ')} onClick={this.selectOpponent.bind(this)}>
        <div className="match-winner-icon" />
        <div className="checkbox" />
        <Contender contender={opponent.contender}/>
      </div>
    );
  }

  private selectOpponent() {
    const { match, selectWinner, opponent } = this.props;
    if (match.state !== 'locked') {
      selectWinner(match.id, opponent.id);
    }
  }
}
