import * as React from 'react';
import { denormalize } from 'normalizr';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import {
  SeriesModel,
  SeriesSchema,
  UserSchema,
  getSeries,
  updateMatch,
} from 'tourney-sdk-react';

import { AppModel } from 'state/model';
import { ReportingSeriesComponent } from './component';

function mapStateToProps(state: AppModel, ownProps: any): any {
  const current = state.tourney.users.current;
  const user = denormalize(current, UserSchema, state.tourney);

  return {
    series: denormalize(ownProps.seriesId, SeriesSchema, state.tourney),
    user
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: any) {
  return bindActionCreators({ getSeries, updateMatch }, dispatch);
}

export const ReportingSeries = connect(mapStateToProps, mapDispatchToProps)(ReportingSeriesComponent);
