import * as React from 'react';
import { Link } from 'react-router';
import { keyBy } from 'lodash';
import {
  TournamentModel,
  UserModel,
  TournamentEntryModel,
  TeamModel,
} from 'tourney-sdk-react';


import { AppModel } from 'state/model';
import { urlForTournament } from 'common/helpers';
import { Button } from 'ui/components/button';

export interface SignupButtonProps {
  tournament: TournamentModel;
  loggedIn?: boolean;
  user: UserModel;
}

export class SignupButtonComponent extends React.Component<AppModel & SignupButtonProps, void> {
  public render() {
    const { tournament, loggedIn, user } = this.props;

    let entry: TournamentEntryModel;
    if (loggedIn) {
      let entriesMap = user.teams.reduce((memo: {[key: string]: TournamentEntryModel}, team: TeamModel) => {
        let results = keyBy(team.tournament_entries, 'tournament_id') as {[key: string]: TournamentEntryModel};
        return {
          ...memo,
          ...results
        };
      }, {});
      entry = entriesMap[tournament.id];
    }

    let buttonProps = {
      size: Button.SIZES.small,
    };

    let text: string;
    if (entry) {
      buttonProps = {
        ...buttonProps,
        disabled: true,
      };
      text = 'Entered';
    } else {
      buttonProps = {
        ...buttonProps,
        primary: true,
      };
      text = 'Sign Up';
    }

    if (tournament.state !== 'registration_open') {
      buttonProps = {
        ...buttonProps,
        hidden: true,
      };
    }

    return (
      <Link to={urlForTournament(tournament)}>
        <Button {...buttonProps}>{text}</Button>
      </Link>
    );
  }
}
