import * as React from 'react';
import { Link } from 'react-router';
import { TournamentModel, UserModel } from 'tourney-sdk-react';

import { AppModel } from 'state/model';
import { Button } from 'ui/components/button';
import { UserAvatar } from 'ui/components/user-avatar';
import { logoutAndRedirect } from 'common/helpers';

const styles = require('./styles.scss');

interface SignupInterceptProps {
  user: UserModel;
  updateUser: Function;
  logoutUser: Function;
}

export class SignupInterceptComponent extends React.Component<any, any> {
  public constructor(props: any){
    super(props);
    this.state = {
      loading: false
    };
  }

  public render() {
    const { user, updateUser, logoutUser } = this.props;

    const boundUpdate = () => {
      let updatedUser = {
        id: user.id,
        settings: {
          tos_accepted: true
        },
      };

      this.setState({ loading: true });
      updateUser(updatedUser);
    };

    const buttonProps = {
      loading: this.state.loading,
      onClick: boundUpdate,
    };

    const logout = () => {
      logoutAndRedirect(logoutUser, '/');
    };

    return(
      <div className="intercept">
        <div className="modal">
          <div className="player-icon">
            <UserAvatar avatar={user.avatar} />
          </div>
          <div className="player-name">
            {user.display_name}
          </div>
          <Button {...buttonProps}>I Accept</Button>
          <div className="tos">
            The <a target="_blank" href="https://www.twitch.tv/p/terms-of-service">Terms of Service</a>
          </div>
          <div className="links-below">
            <span onClick={logout}>Cancel</span> | <a target="_blank" href="https://www.twitch.tv/p/privacy-policy">Privacy Policy</a>
          </div>
        </div>
      </div>
    );
  }
}
